package io.burkard.cdk.services.appmesh

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object Mesh {

  def apply(
    internalResourceId: String,
    egressFilter: Option[software.amazon.awscdk.services.appmesh.MeshFilterType] = None,
    meshName: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.appmesh.Mesh =
    software.amazon.awscdk.services.appmesh.Mesh.Builder
      .create(stackCtx, internalResourceId)
      .egressFilter(egressFilter.orNull)
      .meshName(meshName.orNull)
      .build()
}
