package io.burkard.cdk.services.apigateway

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RequestValidatorProps {

  def apply(
    restApi: software.amazon.awscdk.services.apigateway.IRestApi,
    validateRequestBody: Option[Boolean] = None,
    validateRequestParameters: Option[Boolean] = None,
    requestValidatorName: Option[String] = None
  ): software.amazon.awscdk.services.apigateway.RequestValidatorProps =
    (new software.amazon.awscdk.services.apigateway.RequestValidatorProps.Builder)
      .restApi(restApi)
      .validateRequestBody(validateRequestBody.map(Boolean.box).orNull)
      .validateRequestParameters(validateRequestParameters.map(Boolean.box).orNull)
      .requestValidatorName(requestValidatorName.orNull)
      .build()
}
