package io.burkard.cdk

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object FileFingerprintOptions {

  def apply(
    exclude: Option[List[String]] = None,
    ignoreMode: Option[software.amazon.awscdk.IgnoreMode] = None,
    followSymlinks: Option[software.amazon.awscdk.SymlinkFollowMode] = None,
    extraHash: Option[String] = None
  ): software.amazon.awscdk.FileFingerprintOptions =
    (new software.amazon.awscdk.FileFingerprintOptions.Builder)
      .exclude(exclude.map(_.asJava).orNull)
      .ignoreMode(ignoreMode.orNull)
      .followSymlinks(followSymlinks.orNull)
      .extraHash(extraHash.orNull)
      .build()
}
