package io.burkard.cdk

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object FileAssetLocation {

  def apply(
    bucketName: String,
    objectKey: String,
    s3ObjectUrl: String,
    httpUrl: String
  ): software.amazon.awscdk.FileAssetLocation =
    (new software.amazon.awscdk.FileAssetLocation.Builder)
      .bucketName(bucketName)
      .objectKey(objectKey)
      .s3ObjectUrl(s3ObjectUrl)
      .httpUrl(httpUrl)
      .build()
}
