package io.burkard.cdk.services.servicecatalog

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPortfolioPrincipalAssociationProps {

  def apply(
    principalType: String,
    portfolioId: String,
    principalArn: String,
    acceptLanguage: Option[String] = None
  ): software.amazon.awscdk.services.servicecatalog.CfnPortfolioPrincipalAssociationProps =
    (new software.amazon.awscdk.services.servicecatalog.CfnPortfolioPrincipalAssociationProps.Builder)
      .principalType(principalType)
      .portfolioId(portfolioId)
      .principalArn(principalArn)
      .acceptLanguage(acceptLanguage.orNull)
      .build()
}
