package io.burkard.cdk.services.s3

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object Location {

  def apply(
    bucketName: String,
    objectKey: String,
    objectVersion: Option[String] = None
  ): software.amazon.awscdk.services.s3.Location =
    (new software.amazon.awscdk.services.s3.Location.Builder)
      .bucketName(bucketName)
      .objectKey(objectKey)
      .objectVersion(objectVersion.orNull)
      .build()
}
