package io.burkard.cdk.services.s3

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BucketProps {

  def apply(
    websiteIndexDocument: Option[String] = None,
    lifecycleRules: Option[List[_ <: software.amazon.awscdk.services.s3.LifecycleRule]] = None,
    enforceSsl: Option[Boolean] = None,
    inventories: Option[List[_ <: software.amazon.awscdk.services.s3.Inventory]] = None,
    transferAcceleration: Option[Boolean] = None,
    accessControl: Option[software.amazon.awscdk.services.s3.BucketAccessControl] = None,
    serverAccessLogsPrefix: Option[String] = None,
    intelligentTieringConfigurations: Option[List[_ <: software.amazon.awscdk.services.s3.IntelligentTieringConfiguration]] = None,
    cors: Option[List[_ <: software.amazon.awscdk.services.s3.CorsRule]] = None,
    bucketKeyEnabled: Option[Boolean] = None,
    encryption: Option[software.amazon.awscdk.services.s3.BucketEncryption] = None,
    serverAccessLogsBucket: Option[software.amazon.awscdk.services.s3.IBucket] = None,
    metrics: Option[List[_ <: software.amazon.awscdk.services.s3.BucketMetrics]] = None,
    autoDeleteObjects: Option[Boolean] = None,
    blockPublicAccess: Option[software.amazon.awscdk.services.s3.BlockPublicAccess] = None,
    objectOwnership: Option[software.amazon.awscdk.services.s3.ObjectOwnership] = None,
    websiteRedirect: Option[software.amazon.awscdk.services.s3.RedirectTarget] = None,
    publicReadAccess: Option[Boolean] = None,
    eventBridgeEnabled: Option[Boolean] = None,
    websiteErrorDocument: Option[String] = None,
    encryptionKey: Option[software.amazon.awscdk.services.kms.IKey] = None,
    bucketName: Option[String] = None,
    websiteRoutingRules: Option[List[_ <: software.amazon.awscdk.services.s3.RoutingRule]] = None,
    versioned: Option[Boolean] = None,
    removalPolicy: Option[software.amazon.awscdk.RemovalPolicy] = None
  ): software.amazon.awscdk.services.s3.BucketProps =
    (new software.amazon.awscdk.services.s3.BucketProps.Builder)
      .websiteIndexDocument(websiteIndexDocument.orNull)
      .lifecycleRules(lifecycleRules.map(_.asJava).orNull)
      .enforceSsl(enforceSsl.map(Boolean.box).orNull)
      .inventories(inventories.map(_.asJava).orNull)
      .transferAcceleration(transferAcceleration.map(Boolean.box).orNull)
      .accessControl(accessControl.orNull)
      .serverAccessLogsPrefix(serverAccessLogsPrefix.orNull)
      .intelligentTieringConfigurations(intelligentTieringConfigurations.map(_.asJava).orNull)
      .cors(cors.map(_.asJava).orNull)
      .bucketKeyEnabled(bucketKeyEnabled.map(Boolean.box).orNull)
      .encryption(encryption.orNull)
      .serverAccessLogsBucket(serverAccessLogsBucket.orNull)
      .metrics(metrics.map(_.asJava).orNull)
      .autoDeleteObjects(autoDeleteObjects.map(Boolean.box).orNull)
      .blockPublicAccess(blockPublicAccess.orNull)
      .objectOwnership(objectOwnership.orNull)
      .websiteRedirect(websiteRedirect.orNull)
      .publicReadAccess(publicReadAccess.map(Boolean.box).orNull)
      .eventBridgeEnabled(eventBridgeEnabled.map(Boolean.box).orNull)
      .websiteErrorDocument(websiteErrorDocument.orNull)
      .encryptionKey(encryptionKey.orNull)
      .bucketName(bucketName.orNull)
      .websiteRoutingRules(websiteRoutingRules.map(_.asJava).orNull)
      .versioned(versioned.map(Boolean.box).orNull)
      .removalPolicy(removalPolicy.orNull)
      .build()
}
