package io.burkard.cdk.services.location

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnRouteCalculatorProps {

  def apply(
    dataSource: String,
    pricingPlan: String,
    calculatorName: String,
    description: Option[String] = None
  ): software.amazon.awscdk.services.location.CfnRouteCalculatorProps =
    (new software.amazon.awscdk.services.location.CfnRouteCalculatorProps.Builder)
      .dataSource(dataSource)
      .pricingPlan(pricingPlan)
      .calculatorName(calculatorName)
      .description(description.orNull)
      .build()
}
