package io.burkard.cdk.services.lex.cfnBot

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object FulfillmentStartResponseSpecificationProperty {

  def apply(
    messageGroups: List[_],
    delayInSeconds: Number,
    allowInterrupt: Option[Boolean] = None
  ): software.amazon.awscdk.services.lex.CfnBot.FulfillmentStartResponseSpecificationProperty =
    (new software.amazon.awscdk.services.lex.CfnBot.FulfillmentStartResponseSpecificationProperty.Builder)
      .messageGroups(messageGroups.asJava)
      .delayInSeconds(delayInSeconds)
      .allowInterrupt(allowInterrupt.map(Boolean.box).orNull)
      .build()
}
