package io.burkard.cdk.services.kinesisanalytics.cfnApplicationV2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CheckpointConfigurationProperty {

  def apply(
    configurationType: String,
    checkpointInterval: Option[Number] = None,
    minPauseBetweenCheckpoints: Option[Number] = None,
    checkpointingEnabled: Option[Boolean] = None
  ): software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.CheckpointConfigurationProperty =
    (new software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.CheckpointConfigurationProperty.Builder)
      .configurationType(configurationType)
      .checkpointInterval(checkpointInterval.orNull)
      .minPauseBetweenCheckpoints(minPauseBetweenCheckpoints.orNull)
      .checkpointingEnabled(checkpointingEnabled.map(Boolean.box).orNull)
      .build()
}
