package io.burkard.cdk.services.glue.cfnMLTransform

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object GlueTablesProperty {

  def apply(
    tableName: String,
    databaseName: String,
    catalogId: Option[String] = None,
    connectionName: Option[String] = None
  ): software.amazon.awscdk.services.glue.CfnMLTransform.GlueTablesProperty =
    (new software.amazon.awscdk.services.glue.CfnMLTransform.GlueTablesProperty.Builder)
      .tableName(tableName)
      .databaseName(databaseName)
      .catalogId(catalogId.orNull)
      .connectionName(connectionName.orNull)
      .build()
}
