package io.burkard.cdk.services.events.targets

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CodePipeline {

  def apply(
    pipeline: software.amazon.awscdk.services.codepipeline.IPipeline,
    eventRole: Option[software.amazon.awscdk.services.iam.IRole] = None,
    deadLetterQueue: Option[software.amazon.awscdk.services.sqs.IQueue] = None,
    retryAttempts: Option[Number] = None,
    maxEventAge: Option[software.amazon.awscdk.Duration] = None
  ): software.amazon.awscdk.services.events.targets.CodePipeline =
    software.amazon.awscdk.services.events.targets.CodePipeline.Builder
      .create(pipeline)
      .eventRole(eventRole.orNull)
      .deadLetterQueue(deadLetterQueue.orNull)
      .retryAttempts(retryAttempts.orNull)
      .maxEventAge(maxEventAge.orNull)
      .build()
}
