package io.burkard.cdk.services.elasticsearch

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AdvancedSecurityOptions {

  def apply(
    masterUserPassword: Option[software.amazon.awscdk.SecretValue] = None,
    masterUserName: Option[String] = None,
    masterUserArn: Option[String] = None
  ): software.amazon.awscdk.services.elasticsearch.AdvancedSecurityOptions =
    (new software.amazon.awscdk.services.elasticsearch.AdvancedSecurityOptions.Builder)
      .masterUserPassword(masterUserPassword.orNull)
      .masterUserName(masterUserName.orNull)
      .masterUserArn(masterUserArn.orNull)
      .build()
}
