package io.burkard.cdk.services.dynamodb.cfnGlobalTable

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object GlobalSecondaryIndexProperty {

  def apply(
    indexName: String,
    keySchema: List[_],
    projection: software.amazon.awscdk.services.dynamodb.CfnGlobalTable.ProjectionProperty,
    writeProvisionedThroughputSettings: Option[software.amazon.awscdk.services.dynamodb.CfnGlobalTable.WriteProvisionedThroughputSettingsProperty] = None
  ): software.amazon.awscdk.services.dynamodb.CfnGlobalTable.GlobalSecondaryIndexProperty =
    (new software.amazon.awscdk.services.dynamodb.CfnGlobalTable.GlobalSecondaryIndexProperty.Builder)
      .indexName(indexName)
      .keySchema(keySchema.asJava)
      .projection(projection)
      .writeProvisionedThroughputSettings(writeProvisionedThroughputSettings.orNull)
      .build()
}
