package io.burkard.cdk.services.appmesh

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object VirtualRouterProps {

  def apply(
    mesh: software.amazon.awscdk.services.appmesh.IMesh,
    listeners: Option[List[_ <: software.amazon.awscdk.services.appmesh.VirtualRouterListener]] = None,
    virtualRouterName: Option[String] = None
  ): software.amazon.awscdk.services.appmesh.VirtualRouterProps =
    (new software.amazon.awscdk.services.appmesh.VirtualRouterProps.Builder)
      .mesh(mesh)
      .listeners(listeners.map(_.asJava).orNull)
      .virtualRouterName(virtualRouterName.orNull)
      .build()
}
