package io.burkard.cdk.services.apigateway

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnVpcLinkProps {

  def apply(
    name: String,
    targetArns: List[String],
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    description: Option[String] = None
  ): software.amazon.awscdk.services.apigateway.CfnVpcLinkProps =
    (new software.amazon.awscdk.services.apigateway.CfnVpcLinkProps.Builder)
      .name(name)
      .targetArns(targetArns.asJava)
      .tags(tags.map(_.asJava).orNull)
      .description(description.orNull)
      .build()
}
