package io.burkard.cdk.services.stepfunctions.tasks.emrCreateCluster

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SpotProvisioningSpecificationProperty {

  def apply(
    timeoutAction: software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotTimeoutAction,
    timeoutDurationMinutes: Number,
    blockDurationMinutes: Option[Number] = None,
    allocationStrategy: Option[software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotAllocationStrategy] = None
  ): software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotProvisioningSpecificationProperty =
    (new software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotProvisioningSpecificationProperty.Builder)
      .timeoutAction(timeoutAction)
      .timeoutDurationMinutes(timeoutDurationMinutes)
      .blockDurationMinutes(blockDurationMinutes.orNull)
      .allocationStrategy(allocationStrategy.orNull)
      .build()
}
