package io.burkard.cdk.services.signer

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnSigningProfileProps {

  def apply(
    platformId: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    signatureValidityPeriod: Option[software.amazon.awscdk.services.signer.CfnSigningProfile.SignatureValidityPeriodProperty] = None
  ): software.amazon.awscdk.services.signer.CfnSigningProfileProps =
    (new software.amazon.awscdk.services.signer.CfnSigningProfileProps.Builder)
      .platformId(platformId)
      .tags(tags.map(_.asJava).orNull)
      .signatureValidityPeriod(signatureValidityPeriod.orNull)
      .build()
}
