package io.burkard.cdk.services.secretsmanager

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SecretAttributes {

  def apply(
    encryptionKey: Option[software.amazon.awscdk.services.kms.IKey] = None,
    secretCompleteArn: Option[String] = None,
    secretPartialArn: Option[String] = None
  ): software.amazon.awscdk.services.secretsmanager.SecretAttributes =
    (new software.amazon.awscdk.services.secretsmanager.SecretAttributes.Builder)
      .encryptionKey(encryptionKey.orNull)
      .secretCompleteArn(secretCompleteArn.orNull)
      .secretPartialArn(secretPartialArn.orNull)
      .build()
}
