package io.burkard.cdk.services.s3.deployment

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BucketDeploymentProps {

  def apply(
    destinationBucket: software.amazon.awscdk.services.s3.IBucket,
    sources: List[_ <: software.amazon.awscdk.services.s3.deployment.ISource],
    logRetention: Option[software.amazon.awscdk.services.logs.RetentionDays] = None,
    expires: Option[software.amazon.awscdk.Expiration] = None,
    cacheControl: Option[List[_ <: software.amazon.awscdk.services.s3.deployment.CacheControl]] = None,
    retainOnDelete: Option[Boolean] = None,
    memoryLimit: Option[Number] = None,
    role: Option[software.amazon.awscdk.services.iam.IRole] = None,
    useEfs: Option[Boolean] = None,
    distribution: Option[software.amazon.awscdk.services.cloudfront.IDistribution] = None,
    contentLanguage: Option[String] = None,
    serverSideEncryptionAwsKmsKeyId: Option[String] = None,
    accessControl: Option[software.amazon.awscdk.services.s3.BucketAccessControl] = None,
    websiteRedirectLocation: Option[String] = None,
    storageClass: Option[software.amazon.awscdk.services.s3.deployment.StorageClass] = None,
    vpcSubnets: Option[software.amazon.awscdk.services.ec2.SubnetSelection] = None,
    contentType: Option[String] = None,
    distributionPaths: Option[List[String]] = None,
    prune: Option[Boolean] = None,
    include: Option[List[String]] = None,
    metadata: Option[software.amazon.awscdk.services.s3.deployment.UserDefinedObjectMetadata] = None,
    contentEncoding: Option[String] = None,
    exclude: Option[List[String]] = None,
    vpc: Option[software.amazon.awscdk.services.ec2.IVpc] = None,
    contentDisposition: Option[String] = None,
    serverSideEncryption: Option[software.amazon.awscdk.services.s3.deployment.ServerSideEncryption] = None,
    serverSideEncryptionCustomerAlgorithm: Option[String] = None,
    destinationKeyPrefix: Option[String] = None
  ): software.amazon.awscdk.services.s3.deployment.BucketDeploymentProps =
    (new software.amazon.awscdk.services.s3.deployment.BucketDeploymentProps.Builder)
      .destinationBucket(destinationBucket)
      .sources(sources.asJava)
      .logRetention(logRetention.orNull)
      .expires(expires.orNull)
      .cacheControl(cacheControl.map(_.asJava).orNull)
      .retainOnDelete(retainOnDelete.map(Boolean.box).orNull)
      .memoryLimit(memoryLimit.orNull)
      .role(role.orNull)
      .useEfs(useEfs.map(Boolean.box).orNull)
      .distribution(distribution.orNull)
      .contentLanguage(contentLanguage.orNull)
      .serverSideEncryptionAwsKmsKeyId(serverSideEncryptionAwsKmsKeyId.orNull)
      .accessControl(accessControl.orNull)
      .websiteRedirectLocation(websiteRedirectLocation.orNull)
      .storageClass(storageClass.orNull)
      .vpcSubnets(vpcSubnets.orNull)
      .contentType(contentType.orNull)
      .distributionPaths(distributionPaths.map(_.asJava).orNull)
      .prune(prune.map(Boolean.box).orNull)
      .include(include.map(_.asJava).orNull)
      .metadata(metadata.orNull)
      .contentEncoding(contentEncoding.orNull)
      .exclude(exclude.map(_.asJava).orNull)
      .vpc(vpc.orNull)
      .contentDisposition(contentDisposition.orNull)
      .serverSideEncryption(serverSideEncryption.orNull)
      .serverSideEncryptionCustomerAlgorithm(serverSideEncryptionCustomerAlgorithm.orNull)
      .destinationKeyPrefix(destinationKeyPrefix.orNull)
      .build()
}
