package io.burkard.cdk.services.route53

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RecordSetOptions {

  def apply(
    zone: software.amazon.awscdk.services.route53.IHostedZone,
    ttl: Option[software.amazon.awscdk.Duration] = None,
    comment: Option[String] = None,
    recordName: Option[String] = None
  ): software.amazon.awscdk.services.route53.RecordSetOptions =
    (new software.amazon.awscdk.services.route53.RecordSetOptions.Builder)
      .zone(zone)
      .ttl(ttl.orNull)
      .comment(comment.orNull)
      .recordName(recordName.orNull)
      .build()
}
