package io.burkard.cdk.services.neptune

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDBParameterGroup {

  def apply(
    internalResourceId: String,
    description: String,
    family: String,
    parameters: AnyRef,
    name: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.neptune.CfnDBParameterGroup =
    software.amazon.awscdk.services.neptune.CfnDBParameterGroup.Builder
      .create(stackCtx, internalResourceId)
      .description(description)
      .family(family)
      .parameters(parameters)
      .name(name.orNull)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
