package io.burkard.cdk.services.lambda.nodejs

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BundlingOptions {

  def apply(
    buildArgs: Option[Map[String, String]] = None,
    format: Option[software.amazon.awscdk.services.lambda.nodejs.OutputFormat] = None,
    externalModules: Option[List[String]] = None,
    loader: Option[Map[String, String]] = None,
    assetHash: Option[String] = None,
    preCompilation: Option[Boolean] = None,
    sourceMapMode: Option[software.amazon.awscdk.services.lambda.nodejs.SourceMapMode] = None,
    banner: Option[String] = None,
    dockerImage: Option[software.amazon.awscdk.DockerImage] = None,
    nodeModules: Option[List[String]] = None,
    minify: Option[Boolean] = None,
    forceDockerBundling: Option[Boolean] = None,
    charset: Option[software.amazon.awscdk.services.lambda.nodejs.Charset] = None,
    environment: Option[Map[String, String]] = None,
    sourceMap: Option[Boolean] = None,
    metafile: Option[Boolean] = None,
    target: Option[String] = None,
    tsconfig: Option[String] = None,
    commandHooks: Option[software.amazon.awscdk.services.lambda.nodejs.ICommandHooks] = None,
    sourcesContent: Option[Boolean] = None,
    keepNames: Option[Boolean] = None,
    define: Option[Map[String, String]] = None,
    footer: Option[String] = None,
    logLevel: Option[software.amazon.awscdk.services.lambda.nodejs.LogLevel] = None,
    esbuildVersion: Option[String] = None
  ): software.amazon.awscdk.services.lambda.nodejs.BundlingOptions =
    (new software.amazon.awscdk.services.lambda.nodejs.BundlingOptions.Builder)
      .buildArgs(buildArgs.map(_.asJava).orNull)
      .format(format.orNull)
      .externalModules(externalModules.map(_.asJava).orNull)
      .loader(loader.map(_.asJava).orNull)
      .assetHash(assetHash.orNull)
      .preCompilation(preCompilation.map(Boolean.box).orNull)
      .sourceMapMode(sourceMapMode.orNull)
      .banner(banner.orNull)
      .dockerImage(dockerImage.orNull)
      .nodeModules(nodeModules.map(_.asJava).orNull)
      .minify(minify.map(Boolean.box).orNull)
      .forceDockerBundling(forceDockerBundling.map(Boolean.box).orNull)
      .charset(charset.orNull)
      .environment(environment.map(_.asJava).orNull)
      .sourceMap(sourceMap.map(Boolean.box).orNull)
      .metafile(metafile.map(Boolean.box).orNull)
      .target(target.orNull)
      .tsconfig(tsconfig.orNull)
      .commandHooks(commandHooks.orNull)
      .sourcesContent(sourcesContent.map(Boolean.box).orNull)
      .keepNames(keepNames.map(Boolean.box).orNull)
      .define(define.map(_.asJava).orNull)
      .footer(footer.orNull)
      .logLevel(logLevel.orNull)
      .esbuildVersion(esbuildVersion.orNull)
      .build()
}
