package io.burkard.cdk.services.events.cfnRule

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BatchParametersProperty {

  def apply(
    jobName: String,
    jobDefinition: String,
    retryStrategy: Option[software.amazon.awscdk.services.events.CfnRule.BatchRetryStrategyProperty] = None,
    arrayProperties: Option[software.amazon.awscdk.services.events.CfnRule.BatchArrayPropertiesProperty] = None
  ): software.amazon.awscdk.services.events.CfnRule.BatchParametersProperty =
    (new software.amazon.awscdk.services.events.CfnRule.BatchParametersProperty.Builder)
      .jobName(jobName)
      .jobDefinition(jobDefinition)
      .retryStrategy(retryStrategy.orNull)
      .arrayProperties(arrayProperties.orNull)
      .build()
}
