package io.burkard.cdk.services.eks

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EksOptimizedImage {

  def apply(
    nodeType: Option[software.amazon.awscdk.services.eks.NodeType] = None,
    cpuArch: Option[software.amazon.awscdk.services.eks.CpuArch] = None,
    kubernetesVersion: Option[String] = None
  ): software.amazon.awscdk.services.eks.EksOptimizedImage =
    software.amazon.awscdk.services.eks.EksOptimizedImage.Builder
      .create()
      .nodeType(nodeType.orNull)
      .cpuArch(cpuArch.orNull)
      .kubernetesVersion(kubernetesVersion.orNull)
      .build()
}
