package io.burkard.cdk.services.ec2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnCapacityReservationFleetProps {

  def apply(
    tagSpecifications: Option[List[_]] = None,
    instanceTypeSpecifications: Option[List[_]] = None,
    allocationStrategy: Option[String] = None,
    endDate: Option[String] = None,
    instanceMatchCriteria: Option[String] = None,
    removeEndDate: Option[Boolean] = None,
    noRemoveEndDate: Option[Boolean] = None,
    totalTargetCapacity: Option[Number] = None,
    tenancy: Option[String] = None
  ): software.amazon.awscdk.services.ec2.CfnCapacityReservationFleetProps =
    (new software.amazon.awscdk.services.ec2.CfnCapacityReservationFleetProps.Builder)
      .tagSpecifications(tagSpecifications.map(_.asJava).orNull)
      .instanceTypeSpecifications(instanceTypeSpecifications.map(_.asJava).orNull)
      .allocationStrategy(allocationStrategy.orNull)
      .endDate(endDate.orNull)
      .instanceMatchCriteria(instanceMatchCriteria.orNull)
      .removeEndDate(removeEndDate.map(Boolean.box).orNull)
      .noRemoveEndDate(noRemoveEndDate.map(Boolean.box).orNull)
      .totalTargetCapacity(totalTargetCapacity.orNull)
      .tenancy(tenancy.orNull)
      .build()
}
