package io.burkard.cdk.services.cloudfront.cfnCachePolicy

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ParametersInCacheKeyAndForwardedToOriginProperty {

  def apply(
    headersConfig: software.amazon.awscdk.services.cloudfront.CfnCachePolicy.HeadersConfigProperty,
    enableAcceptEncodingGzip: Boolean,
    cookiesConfig: software.amazon.awscdk.services.cloudfront.CfnCachePolicy.CookiesConfigProperty,
    queryStringsConfig: software.amazon.awscdk.services.cloudfront.CfnCachePolicy.QueryStringsConfigProperty,
    enableAcceptEncodingBrotli: Option[Boolean] = None
  ): software.amazon.awscdk.services.cloudfront.CfnCachePolicy.ParametersInCacheKeyAndForwardedToOriginProperty =
    (new software.amazon.awscdk.services.cloudfront.CfnCachePolicy.ParametersInCacheKeyAndForwardedToOriginProperty.Builder)
      .headersConfig(headersConfig)
      .enableAcceptEncodingGzip(enableAcceptEncodingGzip)
      .cookiesConfig(cookiesConfig)
      .queryStringsConfig(queryStringsConfig)
      .enableAcceptEncodingBrotli(enableAcceptEncodingBrotli.map(Boolean.box).orNull)
      .build()
}
