package io.burkard.cdk.services.appmesh

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object GatewayRouteSpecConfig {

  def apply(
    priority: Option[Number] = None,
    http2SpecConfig: Option[software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRouteProperty] = None,
    httpSpecConfig: Option[software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRouteProperty] = None,
    grpcSpecConfig: Option[software.amazon.awscdk.services.appmesh.CfnGatewayRoute.GrpcGatewayRouteProperty] = None
  ): software.amazon.awscdk.services.appmesh.GatewayRouteSpecConfig =
    (new software.amazon.awscdk.services.appmesh.GatewayRouteSpecConfig.Builder)
      .priority(priority.orNull)
      .http2SpecConfig(http2SpecConfig.orNull)
      .httpSpecConfig(httpSpecConfig.orNull)
      .grpcSpecConfig(grpcSpecConfig.orNull)
      .build()
}
