package io.burkard.cdk.services.apigateway

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CognitoUserPoolsAuthorizerProps {

  def apply(
    cognitoUserPools: List[_ <: software.amazon.awscdk.services.cognito.IUserPool],
    resultsCacheTtl: Option[software.amazon.awscdk.Duration] = None,
    authorizerName: Option[String] = None,
    identitySource: Option[String] = None
  ): software.amazon.awscdk.services.apigateway.CognitoUserPoolsAuthorizerProps =
    (new software.amazon.awscdk.services.apigateway.CognitoUserPoolsAuthorizerProps.Builder)
      .cognitoUserPools(cognitoUserPools.asJava)
      .resultsCacheTtl(resultsCacheTtl.orNull)
      .authorizerName(authorizerName.orNull)
      .identitySource(identitySource.orNull)
      .build()
}
