package io.burkard.cdk

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object DockerVolume {

  def apply(
    containerPath: String,
    hostPath: String,
    consistency: Option[software.amazon.awscdk.DockerVolumeConsistency] = None
  ): software.amazon.awscdk.DockerVolume =
    (new software.amazon.awscdk.DockerVolume.Builder)
      .containerPath(containerPath)
      .hostPath(hostPath)
      .consistency(consistency.orNull)
      .build()
}
