package io.burkard.cdk.services.stepfunctions

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LogOptions {

  def apply(
    destination: software.amazon.awscdk.services.logs.ILogGroup,
    level: Option[software.amazon.awscdk.services.stepfunctions.LogLevel] = None,
    includeExecutionData: Option[Boolean] = None
  ): software.amazon.awscdk.services.stepfunctions.LogOptions =
    (new software.amazon.awscdk.services.stepfunctions.LogOptions.Builder)
      .destination(destination)
      .level(level.orNull)
      .includeExecutionData(includeExecutionData.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
