package io.burkard.cdk.services.route53resolver

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnResolverRuleAssociation {

  def apply(
    internalResourceId: String,
    vpcId: String,
    resolverRuleId: String,
    name: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.route53resolver.CfnResolverRuleAssociation =
    software.amazon.awscdk.services.route53resolver.CfnResolverRuleAssociation.Builder
      .create(stackCtx, internalResourceId)
      .vpcId(vpcId)
      .resolverRuleId(resolverRuleId)
      .name(name.orNull)
      .build()
}
