package io.burkard.cdk.services.route53recoverycontrol

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnRoutingControl {

  def apply(
    internalResourceId: String,
    name: String,
    clusterArn: Option[String] = None,
    controlPanelArn: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.route53recoverycontrol.CfnRoutingControl =
    software.amazon.awscdk.services.route53recoverycontrol.CfnRoutingControl.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .clusterArn(clusterArn.orNull)
      .controlPanelArn(controlPanelArn.orNull)
      .build()
}
