package io.burkard.cdk.services.opensearchservice.cfnDomain

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EBSOptionsProperty {

  def apply(
    volumeSize: Option[Number] = None,
    iops: Option[Number] = None,
    volumeType: Option[String] = None,
    ebsEnabled: Option[Boolean] = None
  ): software.amazon.awscdk.services.opensearchservice.CfnDomain.EBSOptionsProperty =
    (new software.amazon.awscdk.services.opensearchservice.CfnDomain.EBSOptionsProperty.Builder)
      .volumeSize(volumeSize.orNull)
      .iops(iops.orNull)
      .volumeType(volumeType.orNull)
      .ebsEnabled(ebsEnabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
