package io.burkard.cdk.services.lex.cfnBot

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object PromptSpecificationProperty {

  def apply(
    messageGroupsList: List[_],
    maxRetries: Number,
    allowInterrupt: Option[Boolean] = None
  ): software.amazon.awscdk.services.lex.CfnBot.PromptSpecificationProperty =
    (new software.amazon.awscdk.services.lex.CfnBot.PromptSpecificationProperty.Builder)
      .messageGroupsList(messageGroupsList.asJava)
      .maxRetries(maxRetries)
      .allowInterrupt(allowInterrupt.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
