package io.burkard.cdk.services.glue

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPartition {

  def apply(
    internalResourceId: String,
    catalogId: String,
    databaseName: String,
    partitionInput: software.amazon.awscdk.services.glue.CfnPartition.PartitionInputProperty,
    tableName: String
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.glue.CfnPartition =
    software.amazon.awscdk.services.glue.CfnPartition.Builder
      .create(stackCtx, internalResourceId)
      .catalogId(catalogId)
      .databaseName(databaseName)
      .partitionInput(partitionInput)
      .tableName(tableName)
      .build()
}
