package io.burkard.cdk.services.eks.cfnCluster

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object KubernetesNetworkConfigProperty {

  def apply(
    serviceIpv4Cidr: Option[String] = None,
    serviceIpv6Cidr: Option[String] = None,
    ipFamily: Option[String] = None
  ): software.amazon.awscdk.services.eks.CfnCluster.KubernetesNetworkConfigProperty =
    (new software.amazon.awscdk.services.eks.CfnCluster.KubernetesNetworkConfigProperty.Builder)
      .serviceIpv4Cidr(serviceIpv4Cidr.orNull)
      .serviceIpv6Cidr(serviceIpv6Cidr.orNull)
      .ipFamily(ipFamily.orNull)
      .build()
}
