package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EbsDeviceSnapshotOptions {

  def apply(
    volumeSize: Option[Number] = None,
    deleteOnTermination: Option[Boolean] = None,
    iops: Option[Number] = None,
    volumeType: Option[software.amazon.awscdk.services.ec2.EbsDeviceVolumeType] = None
  ): software.amazon.awscdk.services.ec2.EbsDeviceSnapshotOptions =
    (new software.amazon.awscdk.services.ec2.EbsDeviceSnapshotOptions.Builder)
      .volumeSize(volumeSize.orNull)
      .deleteOnTermination(deleteOnTermination.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .iops(iops.orNull)
      .volumeType(volumeType.orNull)
      .build()
}
