package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnVPCGatewayAttachmentProps {

  def apply(
    vpcId: String,
    internetGatewayId: Option[String] = None,
    vpnGatewayId: Option[String] = None
  ): software.amazon.awscdk.services.ec2.CfnVPCGatewayAttachmentProps =
    (new software.amazon.awscdk.services.ec2.CfnVPCGatewayAttachmentProps.Builder)
      .vpcId(vpcId)
      .internetGatewayId(internetGatewayId.orNull)
      .vpnGatewayId(vpnGatewayId.orNull)
      .build()
}
