package io.burkard.cdk.services.codepipeline.actions

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CloudFormationCreateUpdateStackAction {

  def apply(
    adminPermissions: Boolean,
    stackName: String,
    templatePath: software.amazon.awscdk.services.codepipeline.ArtifactPath,
    templateConfiguration: Option[software.amazon.awscdk.services.codepipeline.ArtifactPath] = None,
    role: Option[software.amazon.awscdk.services.iam.IRole] = None,
    outputFileName: Option[String] = None,
    extraInputs: Option[List[_ <: software.amazon.awscdk.services.codepipeline.Artifact]] = None,
    replaceOnFailure: Option[Boolean] = None,
    variablesNamespace: Option[String] = None,
    runOrder: Option[Number] = None,
    actionName: Option[String] = None,
    region: Option[String] = None,
    account: Option[String] = None,
    deploymentRole: Option[software.amazon.awscdk.services.iam.IRole] = None,
    output: Option[software.amazon.awscdk.services.codepipeline.Artifact] = None,
    parameterOverrides: Option[Map[String, _]] = None,
    cfnCapabilities: Option[List[_ <: software.amazon.awscdk.CfnCapabilities]] = None
  ): software.amazon.awscdk.services.codepipeline.actions.CloudFormationCreateUpdateStackAction =
    software.amazon.awscdk.services.codepipeline.actions.CloudFormationCreateUpdateStackAction.Builder
      .create()
      .adminPermissions(adminPermissions)
      .stackName(stackName)
      .templatePath(templatePath)
      .templateConfiguration(templateConfiguration.orNull)
      .role(role.orNull)
      .outputFileName(outputFileName.orNull)
      .extraInputs(extraInputs.map(_.asJava).orNull)
      .replaceOnFailure(replaceOnFailure.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .variablesNamespace(variablesNamespace.orNull)
      .runOrder(runOrder.orNull)
      .actionName(actionName.orNull)
      .region(region.orNull)
      .account(account.orNull)
      .deploymentRole(deploymentRole.orNull)
      .output(output.orNull)
      .parameterOverrides(parameterOverrides.map(_.asJava).orNull)
      .cfnCapabilities(cfnCapabilities.map(_.asJava).orNull)
      .build()
}
