package io.burkard.cdk.services.certificatemanager

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object Certificate {

  def apply(
    internalResourceId: String,
    domainName: String,
    validation: Option[software.amazon.awscdk.services.certificatemanager.CertificateValidation] = None,
    subjectAlternativeNames: Option[List[String]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.certificatemanager.Certificate =
    software.amazon.awscdk.services.certificatemanager.Certificate.Builder
      .create(stackCtx, internalResourceId)
      .domainName(domainName)
      .validation(validation.orNull)
      .subjectAlternativeNames(subjectAlternativeNames.map(_.asJava).orNull)
      .build()
}
