package io.burkard.cdk.services.autoscalingplans

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnScalingPlan {

  def apply(
    internalResourceId: String,
    applicationSource: software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan.ApplicationSourceProperty,
    scalingInstructions: List[_]
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan =
    software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan.Builder
      .create(stackCtx, internalResourceId)
      .applicationSource(applicationSource)
      .scalingInstructions(scalingInstructions.asJava)
      .build()
}
