package io.burkard.cdk.services.appstream

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnFleet {

  def apply(
    internalResourceId: String,
    name: String,
    instanceType: String,
    displayName: Option[String] = None,
    imageArn: Option[String] = None,
    domainJoinInfo: Option[software.amazon.awscdk.services.appstream.CfnFleet.DomainJoinInfoProperty] = None,
    iamRoleArn: Option[String] = None,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    idleDisconnectTimeoutInSeconds: Option[Number] = None,
    vpcConfig: Option[software.amazon.awscdk.services.appstream.CfnFleet.VpcConfigProperty] = None,
    imageName: Option[String] = None,
    enableDefaultInternetAccess: Option[Boolean] = None,
    disconnectTimeoutInSeconds: Option[Number] = None,
    streamView: Option[String] = None,
    maxConcurrentSessions: Option[Number] = None,
    fleetType: Option[String] = None,
    maxUserDurationInSeconds: Option[Number] = None,
    platform: Option[String] = None,
    computeCapacity: Option[software.amazon.awscdk.services.appstream.CfnFleet.ComputeCapacityProperty] = None,
    usbDeviceFilterStrings: Option[List[String]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.appstream.CfnFleet =
    software.amazon.awscdk.services.appstream.CfnFleet.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .instanceType(instanceType)
      .displayName(displayName.orNull)
      .imageArn(imageArn.orNull)
      .domainJoinInfo(domainJoinInfo.orNull)
      .iamRoleArn(iamRoleArn.orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .idleDisconnectTimeoutInSeconds(idleDisconnectTimeoutInSeconds.orNull)
      .vpcConfig(vpcConfig.orNull)
      .imageName(imageName.orNull)
      .enableDefaultInternetAccess(enableDefaultInternetAccess.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .disconnectTimeoutInSeconds(disconnectTimeoutInSeconds.orNull)
      .streamView(streamView.orNull)
      .maxConcurrentSessions(maxConcurrentSessions.orNull)
      .fleetType(fleetType.orNull)
      .maxUserDurationInSeconds(maxUserDurationInSeconds.orNull)
      .platform(platform.orNull)
      .computeCapacity(computeCapacity.orNull)
      .usbDeviceFilterStrings(usbDeviceFilterStrings.map(_.asJava).orNull)
      .build()
}
