package io.burkard.cdk.services.appmesh

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object VirtualGatewayBaseProps {

  def apply(
    listeners: Option[List[_ <: software.amazon.awscdk.services.appmesh.VirtualGatewayListener]] = None,
    accessLog: Option[software.amazon.awscdk.services.appmesh.AccessLog] = None,
    backendDefaults: Option[software.amazon.awscdk.services.appmesh.BackendDefaults] = None,
    virtualGatewayName: Option[String] = None
  ): software.amazon.awscdk.services.appmesh.VirtualGatewayBaseProps =
    (new software.amazon.awscdk.services.appmesh.VirtualGatewayBaseProps.Builder)
      .listeners(listeners.map(_.asJava).orNull)
      .accessLog(accessLog.orNull)
      .backendDefaults(backendDefaults.orNull)
      .virtualGatewayName(virtualGatewayName.orNull)
      .build()
}
