package io.burkard.cdk.cloudassembly.schema

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BootstrapRole {

  def apply(
    arn: String,
    bootstrapStackVersionSsmParameter: Option[String] = None,
    assumeRoleExternalId: Option[String] = None,
    requiresBootstrapStackVersion: Option[Number] = None
  ): software.amazon.awscdk.cloudassembly.schema.BootstrapRole =
    (new software.amazon.awscdk.cloudassembly.schema.BootstrapRole.Builder)
      .arn(arn)
      .bootstrapStackVersionSsmParameter(bootstrapStackVersionSsmParameter.orNull)
      .assumeRoleExternalId(assumeRoleExternalId.orNull)
      .requiresBootstrapStackVersion(requiresBootstrapStackVersion.orNull)
      .build()
}
