package io.burkard.cdk

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnRule {

  def apply(
    internalResourceId: String,
    ruleCondition: Option[software.amazon.awscdk.ICfnConditionExpression] = None,
    assertions: Option[List[_ <: software.amazon.awscdk.CfnRuleAssertion]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.CfnRule =
    software.amazon.awscdk.CfnRule.Builder
      .create(stackCtx, internalResourceId)
      .ruleCondition(ruleCondition.orNull)
      .assertions(assertions.map(_.asJava).orNull)
      .build()
}
