package io.burkard.cdk

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AssetOptions {

  def apply(
    assetHashType: Option[software.amazon.awscdk.AssetHashType] = None,
    bundling: Option[software.amazon.awscdk.BundlingOptions] = None,
    assetHash: Option[String] = None
  ): software.amazon.awscdk.AssetOptions =
    (new software.amazon.awscdk.AssetOptions.Builder)
      .assetHashType(assetHashType.orNull)
      .bundling(bundling.orNull)
      .assetHash(assetHash.orNull)
      .build()
}
