package io.burkard.cdk.services.stepfunctions.cfnStateMachine

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LoggingConfigurationProperty {

  def apply(
    level: Option[String] = None,
    destinations: Option[List[_]] = None,
    includeExecutionData: Option[Boolean] = None
  ): software.amazon.awscdk.services.stepfunctions.CfnStateMachine.LoggingConfigurationProperty =
    (new software.amazon.awscdk.services.stepfunctions.CfnStateMachine.LoggingConfigurationProperty.Builder)
      .level(level.orNull)
      .destinations(destinations.map(_.asJava).orNull)
      .includeExecutionData(includeExecutionData.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
