package io.burkard.cdk.services.ssm

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object StringParameter {

  def apply(
    internalResourceId: String,
    stringValue: String,
    simpleName: Option[Boolean] = None,
    tier: Option[software.amazon.awscdk.services.ssm.ParameterTier] = None,
    description: Option[String] = None,
    parameterName: Option[String] = None,
    dataType: Option[software.amazon.awscdk.services.ssm.ParameterDataType] = None,
    `type`: Option[software.amazon.awscdk.services.ssm.ParameterType] = None,
    allowedPattern: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ssm.StringParameter =
    software.amazon.awscdk.services.ssm.StringParameter.Builder
      .create(stackCtx, internalResourceId)
      .stringValue(stringValue)
      .simpleName(simpleName.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .tier(tier.orNull)
      .description(description.orNull)
      .parameterName(parameterName.orNull)
      .dataType(dataType.orNull)
      .`type`(`type`.orNull)
      .allowedPattern(allowedPattern.orNull)
      .build()
}
