package io.burkard.cdk.services.s3.cfnStorageLens

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object StorageLensConfigurationProperty {

  def apply(
    accountLevel: software.amazon.awscdk.services.s3.CfnStorageLens.AccountLevelProperty,
    id: String,
    isEnabled: Boolean,
    awsOrg: Option[software.amazon.awscdk.services.s3.CfnStorageLens.AwsOrgProperty] = None,
    storageLensArn: Option[String] = None,
    dataExport: Option[software.amazon.awscdk.services.s3.CfnStorageLens.DataExportProperty] = None,
    include: Option[software.amazon.awscdk.services.s3.CfnStorageLens.BucketsAndRegionsProperty] = None,
    exclude: Option[software.amazon.awscdk.services.s3.CfnStorageLens.BucketsAndRegionsProperty] = None
  ): software.amazon.awscdk.services.s3.CfnStorageLens.StorageLensConfigurationProperty =
    (new software.amazon.awscdk.services.s3.CfnStorageLens.StorageLensConfigurationProperty.Builder)
      .accountLevel(accountLevel)
      .id(id)
      .isEnabled(isEnabled)
      .awsOrg(awsOrg.orNull)
      .storageLensArn(storageLensArn.orNull)
      .dataExport(dataExport.orNull)
      .include(include.orNull)
      .exclude(exclude.orNull)
      .build()
}
